/*
 * Decompiled with CFR 0.152.
 */
package com.example.worldresetmod;

import com.example.worldresetmod.DeletionDiagnosticUtil;
import com.example.worldresetmod.EnhancedAdminDeleteUtil;
import com.example.worldresetmod.WorldResetMod;
import java.io.File;
import java.nio.file.Files;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class FileDeleteUtil {
    private static final Minecraft mc = Minecraft.func_71410_x();

    public static void deleteOverlastDatFile(String worldName) {
        try {
            if (!FileDeleteUtil.isValidWorldName(worldName)) {
                throw new SecurityException("Invalid world name: " + worldName);
            }
            File savesDir = FileDeleteUtil.getSavesDirectory();
            if (savesDir == null || !savesDir.exists()) {
                throw new RuntimeException("Minecraft saves directory not found");
            }
            File overlastFile = new File(savesDir, worldName + "/data/overlast.dat");
            String absolutePath = overlastFile.getAbsolutePath();
            if (!FileDeleteUtil.isFilePathSafe(overlastFile, savesDir)) {
                throw new SecurityException("File path security check failed");
            }
            File worldDir = new File(savesDir, worldName);
            if (!worldDir.exists()) {
                throw new RuntimeException("World directory does not exist: " + worldName);
            }
            File dataDir = new File(worldDir, "data");
            if (!dataDir.exists()) {
                dataDir.mkdirs();
                if (!dataDir.exists()) {
                    throw new RuntimeException("Cannot create data directory");
                }
            }
            if (!overlastFile.exists()) {
                return;
            }
            if (!overlastFile.canWrite()) {
                overlastFile.setWritable(true);
            }
            boolean deleted = false;
            String lastError = null;
            try {
                deleted = overlastFile.delete();
            }
            catch (SecurityException e) {
                lastError = "SecurityException: " + e.getMessage();
            }
            if (!deleted) {
                try {
                    Files.deleteIfExists(overlastFile.toPath());
                    deleted = !overlastFile.exists();
                }
                catch (Exception e) {
                    lastError = "NIO delete error: " + e.getMessage();
                }
            }
            if (!deleted) {
                deleted = EnhancedAdminDeleteUtil.performEnhancedAdminDelete(absolutePath);
            }
            if (!deleted) {
                String diagnosticReport = DeletionDiagnosticUtil.analyzeDeletionFailure(overlastFile);
                WorldResetMod.logger.error("=== DELETION DIAGNOSTICS ===");
                WorldResetMod.logger.error(diagnosticReport);
                deleted = FileDeleteUtil.performOwnershipChangeDeletion(absolutePath);
                if (!deleted) {
                    deleted = EnhancedAdminDeleteUtil.performEnhancedAdminDelete(absolutePath);
                }
                if (!deleted) {
                    deleted = EnhancedAdminDeleteUtil.requestUACElevation(absolutePath);
                }
                if (!deleted) {
                    FileDeleteUtil.stopFileLockingProcesses(absolutePath);
                    Thread.sleep(3000L);
                    deleted = overlastFile.delete();
                }
                if (!deleted) {
                    deleted = FileDeleteUtil.performWindowsAPIDeletion(absolutePath);
                }
            }
            if (!deleted) {
                WorldResetMod.logger.error("All deletion methods failed! Last error: " + lastError);
                WorldResetMod.logger.error("Manual deletion required for: " + absolutePath);
            }
        }
        catch (Exception e) {
            WorldResetMod.logger.error("Exception during file deletion", (Throwable)e);
            throw new RuntimeException("File deletion failed", e);
        }
    }

    public static boolean enhancedDeleteFile(File file) {
        return EnhancedAdminDeleteUtil.performEnhancedAdminDelete(file.getAbsolutePath());
    }

    private static boolean performOwnershipChangeDeletion(String filePath) {
        try {
            Process process = new ProcessBuilder("cmd.exe", "/c", "takeown /f \"" + filePath + "\" && icacls \"" + filePath + "\" /grant %USERNAME%:F && del /F /Q \"" + filePath + "\"").start();
            process.waitFor();
            return !new File(filePath).exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void stopFileLockingProcesses(String filePath) {
        String[] processesToStop;
        for (String processName : processesToStop = new String[]{"javaw.exe", "java.exe", "MinecraftLauncher.exe"}) {
            try {
                new ProcessBuilder("taskkill", "/f", "/im", processName).start().waitFor();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static boolean performWindowsAPIDeletion(String filePath) {
        try {
            Process process = new ProcessBuilder("powershell.exe", "-Command", "Add-Type -AssemblyName System.IO.Compression.FileSystem; $file = [System.IO.File]::OpenWrite('" + filePath + "'); $file.Close(); Remove-Item -Path '" + filePath + "' -Force").start();
            process.waitFor();
            return !new File(filePath).exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    private static File getSavesDirectory() {
        try {
            if (mc == null || FileDeleteUtil.mc.field_71412_D == null) {
                return null;
            }
            return new File(FileDeleteUtil.mc.field_71412_D, "saves");
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean isValidWorldName(String worldName) {
        if (worldName == null || worldName.trim().isEmpty()) {
            return false;
        }
        return !worldName.contains("..") && !worldName.contains("/") && !worldName.contains("\\") && !worldName.contains("<>:\\\"|?*");
    }

    private static boolean isFilePathSafe(File file, File baseDir) {
        try {
            String filePath = file.getCanonicalPath();
            String basePath = baseDir.getCanonicalPath();
            return filePath.startsWith(basePath);
        }
        catch (Exception e) {
            return false;
        }
    }
}

